unit MyCoreModelUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Entidade = class;
  Telefone = class;
  [UmlElement('Package', Id='AADA7288-18CD-4E6B-A899-D08F8C0F1266')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Telefone))]
  [UmlMetaAttribute('ownedElement', TypeOf(Entidade))]
  MyCoreModel = class
  public
  type
    [UmlElement('Association', Id='b3337479-d827-40aa-971b-635d5fc5d9be')]
    TelefoneTelefonesEntidadeEntidade = class
    end;
  end;

  [assembly: RuntimeRequired(TypeOf(MyCoreModel))]
  ITelefoneList = interface;
  IEntidadeList = interface;
  
  [UmlCollection(TypeOf(Telefone))]
  ITelefoneList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Telefone;
    procedure set_Item(index: Integer; Value: Telefone);
    property Item[index: Integer]: Telefone read get_Item write set_Item; default;
    function Add(value: Telefone): Integer;
    function Contains(value: Telefone): Boolean;
    function IndexOf(value: Telefone): Integer;
    procedure Insert(index: Integer; value: Telefone);
    procedure Remove(value: Telefone);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='b50055c1-356e-454e-8d81-d59c63d084bf')]
  Telefone = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Numero = Eco_FirstMember;
    const
      Ramal = (Eco_LoopbackIndices.Numero + 1);
    const
      DDD = (Eco_LoopbackIndices.Ramal + 1);
    const
      Entidade = (Eco_LoopbackIndices.DDD + 1);
    end;

    TelefoneListAdapter = class(ObjectListAdapter, ITelefoneList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Telefone;
      procedure set_Item(index: Integer; Value: Telefone);
      property Item[index: Integer]: Telefone read get_Item write set_Item; default;
      function Add(value: Telefone): Integer;
      function Contains(value: Telefone): Boolean;
      function IndexOf(value: Telefone): Integer;
      procedure Insert(index: Integer; value: Telefone);
      procedure Remove(value: Telefone);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Entidade: Entidade;
    procedure set_Entidade(Value: Entidade);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Entidade, Id='43bd97f' +
    'c-6d99-4ee3-8958-c281ad96fe9f')]
    [UmlMetaAttribute('association', TypeOf(MyCoreModel.TelefoneTelefonesEntidadeEntidade), Index=1)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Entidade: Entidade read get_Entidade write set_Entidade;
    function get_DDD: Integer;
    procedure set_DDD(Value: Integer);
    [UmlElement(Id='6976656b-2fe2-4a39-abed-226195665bf4', Index=Eco_LoopbackIndices.DDD)]
    property DDD: Integer read get_DDD write set_DDD;
    function get_Numero: string;
    procedure set_Numero(Value: string);
    [UmlElement(Id='377748d8-88ab-4bd3-81c8-b9bf788574bd', Index=Eco_LoopbackIndices.Numero)]
    property Numero: string read get_Numero write set_Numero;
    function get_Ramal: Integer;
    procedure set_Ramal(Value: Integer);
    [UmlElement(Id='43ef4775-73bd-4631-b761-675acdb0bb95', Index=Eco_LoopbackIndices.Ramal)]
    property Ramal: Integer read get_Ramal write set_Ramal;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  
  [UmlCollection(TypeOf(Entidade))]
  IEntidadeList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Entidade;
    procedure set_Item(index: Integer; Value: Entidade);
    property Item[index: Integer]: Entidade read get_Item write set_Item; default;
    function Add(value: Entidade): Integer;
    function Contains(value: Entidade): Boolean;
    function IndexOf(value: Entidade): Integer;
    procedure Insert(index: Integer; value: Entidade);
    procedure Remove(value: Entidade);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='f97c9f5f-6fb5-4d1d-a4af-5c4143bbad60')]
  Entidade = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Nome = Eco_FirstMember;
    const
      Email = (Eco_LoopbackIndices.Nome + 1);
    const
      Telefones = (Eco_LoopbackIndices.Email + 1);
    end;

    EntidadeListAdapter = class(ObjectListAdapter, IEntidadeList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Entidade;
      procedure set_Item(index: Integer; Value: Entidade);
      property Item[index: Integer]: Entidade read get_Item write set_Item; default;
      function Add(value: Entidade): Integer;
      function Contains(value: Entidade): Boolean;
      function IndexOf(value: Entidade): Integer;
      procedure Insert(index: Integer; value: Entidade);
      procedure Remove(value: Entidade);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Email: string;
    procedure set_Email(Value: string);
    [UmlElement(Id='80d36731-f92c-412e-9f73-d463af68dc4c', Index=Eco_LoopbackIndices.Email)]
    property Email: string read get_Email write set_Email;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='29201cf9-176c-4d1c-8692-00e6cd84697f', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
    function get_Telefones: ITelefoneList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Telefones, Id='dd944d' +
    '81-2a29-4bb1-8044-070c656c65c8')]
    [UmlMetaAttribute('association', TypeOf(MyCoreModel.TelefoneTelefonesEntidadeEntidade), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Telefones: ITelefoneList read get_Telefones;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Entidade.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Entidade.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Entidade.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Entidade.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Entidade.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Entidade.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Entidade.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Entidade.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor Entidade.EntidadeListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Entidade.EntidadeListAdapter.get_Item(index: Integer): Entidade;
begin
  Result := (MyCoreModelUnit.Entidade(inherited Adaptee[index]));
end;

procedure Entidade.EntidadeListAdapter.set_Item(index: Integer; Value: Entidade);
begin
  inherited Adaptee[index] := value;
end;

function Entidade.EntidadeListAdapter.Add(value: Entidade): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Entidade.EntidadeListAdapter.Contains(value: Entidade): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Entidade.EntidadeListAdapter.IndexOf(value: Entidade): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Entidade.EntidadeListAdapter.Insert(index: Integer; value: Entidade);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Entidade.EntidadeListAdapter.Remove(value: Entidade);
begin
  Self.Adaptee.Remove(value);
end;

function Entidade.get_Telefones: ITelefoneList;
begin
  Result := MyCoreModelUnit.Telefone.TelefoneListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Telefones))));
end;

function Entidade.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Entidade.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

function Entidade.get_Email: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
end;

procedure Entidade.set_Email(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, (System.Object(Value)));
end;

function Telefone.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Telefone.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Telefone.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Telefone.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Telefone.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Telefone.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Telefone.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Telefone.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor Telefone.TelefoneListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Telefone.TelefoneListAdapter.get_Item(index: Integer): Telefone;
begin
  Result := (MyCoreModelUnit.Telefone(inherited Adaptee[index]));
end;

procedure Telefone.TelefoneListAdapter.set_Item(index: Integer; Value: Telefone);
begin
  inherited Adaptee[index] := value;
end;

function Telefone.TelefoneListAdapter.Add(value: Telefone): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Telefone.TelefoneListAdapter.Contains(value: Telefone): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Telefone.TelefoneListAdapter.IndexOf(value: Telefone): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Telefone.TelefoneListAdapter.Insert(index: Integer; value: Telefone);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Telefone.TelefoneListAdapter.Remove(value: Telefone);
begin
  Self.Adaptee.Remove(value);
end;

function Telefone.get_Ramal: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Ramal)));
end;

procedure Telefone.set_Ramal(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Ramal, (System.Object(Value)));
end;

function Telefone.get_Numero: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Numero)));
end;

procedure Telefone.set_Numero(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Numero, (System.Object(Value)));
end;

function Telefone.get_DDD: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.DDD)));
end;

procedure Telefone.set_DDD(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.DDD, (System.Object(Value)));
end;

function Telefone.get_Entidade: Entidade;
begin
  Result := (MyCoreModelUnit.Entidade(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Entidade)));
end;

procedure Telefone.set_Entidade(Value: Entidade);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Entidade, (System.Object(Value)));
end;

{ Package_1 }


end.
